var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var CpuCountersDataSeries = (function () {
                    function CpuCountersDataSeries(counterId, timespan, unitConverter, colorScheme, drawFill, title, tooltip) {
                        var _this = this;
                        this._cachedPoints = [];
                        this._drawFill = false;
                        this._dataWarehouseRequestHandle = 1;
                        this._droppedRequest = false;
                        this._currentTimespan = new DiagnosticsHub.JsonTimespan(DiagnosticsHub.BigNumber.zero, DiagnosticsHub.BigNumber.zero);
                        this._seriesMin = 0;
                        this._seriesMax = 0;
                        this._newDataEvent = new DiagnosticsHub.AggregatedEvent();
                        this._samples = 250;
                        this._currentTimespan = timespan;
                        this._unitConverter = unitConverter;
                        this._colorScheme = colorScheme;
                        this._drawFill = drawFill;
                        this._title = title;
                        this._tooltip = tooltip;
                        this._marker = document.createElement("div");
                        this._marker.classList.add("countersDataSeries-marker");
                        this._marker.style.backgroundColor = this._colorScheme.lineColor;
                        this._marker.style.width = (2 * CpuCountersDataSeries.PointRadiusInPixels) + "px";
                        this._marker.style.height = (2 * CpuCountersDataSeries.PointRadiusInPixels) + "px";
                        Microsoft.VisualStudio.DiagnosticsHub.DataWarehouse.loadDataWarehouse()
                            .then(function (dw) {
                            var countersContextData = {
                                customDomain: {
                                    Task: "GetCounter",
                                    CounterId: counterId
                                }
                            };
                            return dw.getFilteredData(countersContextData, CpuCountersDataSeries.analyzerId);
                        }).then(function (responseData) {
                            _this._countersResult = responseData;
                        }).done(function () {
                            _this._dataWarehouseRequestHandle = null;
                            _this._droppedRequest = false;
                            _this.requestUpdate();
                        });
                    }
                    Object.defineProperty(CpuCountersDataSeries, "analyzerId", {
                        get: function () {
                            return "66EDDDF1-2277-40F3-983A-6FF57A433ECB";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CpuCountersDataSeries.prototype, "cachedPoints", {
                        get: function () {
                            return this._cachedPoints;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CpuCountersDataSeries.prototype, "minValue", {
                        get: function () {
                            return this._seriesMin;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CpuCountersDataSeries.prototype, "maxValue", {
                        get: function () {
                            return this._seriesMax;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CpuCountersDataSeries.prototype, "marker", {
                        get: function () {
                            return this._marker;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CpuCountersDataSeries.prototype, "title", {
                        get: function () {
                            return this._title;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CpuCountersDataSeries.prototype, "tooltip", {
                        get: function () {
                            return this._tooltip;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CpuCountersDataSeries.prototype, "newDataEvent", {
                        get: function () {
                            return this._newDataEvent;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    CpuCountersDataSeries.prototype.dispose = function () {
                        this._countersResult.dispose();
                        this._newDataEvent.dispose();
                    };
                    CpuCountersDataSeries.prototype.onViewportChanged = function (viewport) {
                        this._currentTimespan = viewport;
                        this.requestUpdate();
                    };
                    CpuCountersDataSeries.prototype.onDataUpdate = function (timestampNs) {
                        var cachedPointCount = this._cachedPoints.length;
                        if (this._currentTimespan.contains(timestampNs) || cachedPointCount === 0) {
                            this.requestUpdate();
                        }
                        else if (cachedPointCount > 0 &&
                            this._currentTimespan.end.greater(this._cachedPoints[cachedPointCount - 1].Timestamp)) {
                            this.requestUpdate();
                        }
                    };
                    CpuCountersDataSeries.prototype.getPointAtTimestamp = function (timestamp, pointToFind) {
                        if (pointToFind === void 0) { pointToFind = DiagnosticsHub.PointToFind.Nearest; }
                        if (this._cachedPoints.length === 0) {
                            return null;
                        }
                        var point = { Timestamp: timestamp, Value: 0 };
                        var pointCompare = function (left, right) {
                            return right.Timestamp.greater(left.Timestamp);
                        };
                        switch (pointToFind) {
                            case DiagnosticsHub.PointToFind.LessThanOrEqual:
                                var index = DiagnosticsHub.Utilities.findLessThan(this._cachedPoints, point, pointCompare);
                                point = this._cachedPoints[index];
                                break;
                            case DiagnosticsHub.PointToFind.GreaterThanOrEqual:
                                var index = DiagnosticsHub.Utilities.findGreaterThan(this._cachedPoints, point, pointCompare);
                                point = this._cachedPoints[index];
                                break;
                            case DiagnosticsHub.PointToFind.Nearest:
                            default:
                                var minIndex = DiagnosticsHub.Utilities.findLessThan(this._cachedPoints, point, pointCompare);
                                var maxIndex = Math.min(minIndex + 1, this._cachedPoints.length - 1);
                                var minDelta = DiagnosticsHub.BigNumber.subtract(timestamp, this._cachedPoints[minIndex].Timestamp);
                                var maxDelta = DiagnosticsHub.BigNumber.subtract(this._cachedPoints[maxIndex].Timestamp, timestamp);
                                var index = minDelta.greater(maxDelta) ? maxIndex : minIndex;
                                point = this._cachedPoints[index];
                                break;
                        }
                        return {
                            timestamp: point.Timestamp,
                            tooltip: Microsoft.Plugin.Resources.getString("/DiagnosticsHubControlsResources/ChartSeriesFormattableTooltipLabel", this._unitConverter.formatNumber(point.Value)),
                            value: point.Value,
                            color: this._colorScheme
                        };
                    };
                    CpuCountersDataSeries.prototype.draw = function (context, graphInformation) {
                        if (this._cachedPoints.length === 0 || graphInformation.gridX.elapsed.equals(DiagnosticsHub.BigNumber.zero) || graphInformation.chartRect.width <= 0) {
                            return;
                        }
                        if (graphInformation.chartRect.width !== this._samples) {
                            this._samples = graphInformation.chartRect.width;
                            this.requestUpdate();
                        }
                        var getYCoordinate = function (value) { return graphInformation.chartRect.height - DiagnosticsHub.Utilities.scaleToRange(value, graphInformation.gridY.min, graphInformation.gridY.max, 0, graphInformation.chartRect.height); };
                        var getXCoordinate = function (timestamp) { return DiagnosticsHub.Utilities.convertToPixel(timestamp, graphInformation.gridX, graphInformation.chartRect.width, false); };
                        context.save();
                        context.lineWidth = (graphInformation.chartRect.height < 100 ? 1 : 2);
                        context.fillStyle = this._colorScheme.lineFillColor;
                        context.strokeStyle = this._colorScheme.lineColor;
                        var initialxPx = Microsoft.Plugin.F12 ? 0 : getXCoordinate(this._cachedPoints[0].Timestamp);
                        context.beginPath();
                        context.moveTo(initialxPx, getYCoordinate(this._cachedPoints[0].Value));
                        this._cachedPoints.forEach(function (point) { return context.lineTo(getXCoordinate(point.Timestamp), getYCoordinate(point.Value)); });
                        context.stroke();
                        if (this._drawFill) {
                            context.lineTo(getXCoordinate(this._cachedPoints[this._cachedPoints.length - 1].Timestamp), getYCoordinate(graphInformation.gridY.min));
                            context.lineTo(initialxPx, graphInformation.chartRect.height);
                            context.closePath();
                            context.fill();
                        }
                        var elapsedPerPixel = DiagnosticsHub.BigNumber.divideNumber(graphInformation.gridX.elapsed, graphInformation.chartRect.width);
                        if (DiagnosticsHub.BigNumber.convertFromNumber(CpuCountersDataSeries.CounterFrequencyPerPixel).greater(elapsedPerPixel)) {
                            this._cachedPoints.forEach(function (point) {
                                context.beginPath();
                                context.arc(getXCoordinate(point.Timestamp), getYCoordinate(point.Value), CpuCountersDataSeries.PointRadiusInPixels, 0, 2 * Math.PI);
                                context.fill();
                            });
                        }
                        context.restore();
                    };
                    CpuCountersDataSeries.prototype.requestUpdate = function () {
                        var _this = this;
                        if (this._dataWarehouseRequestHandle) {
                            this._droppedRequest = true;
                            return;
                        }
                        this._dataWarehouseRequestHandle = window.setTimeout(function () {
                            if (_this._currentTimespan.elapsed.equals(DiagnosticsHub.BigNumber.zero)) {
                                _this._dataWarehouseRequestHandle = null;
                                return;
                            }
                            var bufferTime = DiagnosticsHub.BigNumber.divideNumber(_this._currentTimespan.elapsed, 2);
                            var bufferStart = DiagnosticsHub.BigNumber.subtract(_this._currentTimespan.begin, DiagnosticsHub.BigNumber.min(bufferTime, _this._currentTimespan.begin));
                            var snappedStart = DiagnosticsHub.BigNumber.multiply(DiagnosticsHub.BigNumber.divide(bufferStart, _this._currentTimespan.elapsed), _this._currentTimespan.elapsed);
                            var snappedEnd = DiagnosticsHub.BigNumber.add(snappedStart, DiagnosticsHub.BigNumber.multiplyNumber(_this._currentTimespan.elapsed, 3));
                            var requestData = {
                                type: "SamplePoints",
                                begin: snappedStart.jsonValue,
                                end: snappedEnd.jsonValue,
                                samples: Math.max(_this._samples, 2)
                            };
                            _this._countersResult.getResult(requestData)
                                .then(function (result) { return _this.cachePoints(result); })
                                .done(function () {
                                _this._dataWarehouseRequestHandle = null;
                                if (_this._droppedRequest) {
                                    window.setTimeout(_this.requestUpdate.bind(_this), DiagnosticsHub.Constants.TimeoutImmediate);
                                    _this._droppedRequest = false;
                                }
                            });
                        }, DiagnosticsHub.Constants.TimeoutImmediate);
                    };
                    CpuCountersDataSeries.prototype.cachePoints = function (result) {
                        var _this = this;
                        this._cachedPoints = result.p.map(function (point) {
                            var timestamp = new DiagnosticsHub.BigNumber(point.t.h, point.t.l);
                            _this._seriesMin = Math.min(_this._seriesMin, point.v);
                            _this._seriesMax = Math.max(_this._seriesMax, point.v);
                            return {
                                Timestamp: timestamp,
                                Value: point.v,
                                ToolTip: point.tt
                            };
                        });
                        this._newDataEvent.invokeEvent(this);
                    };
                    CpuCountersDataSeries.PointRadiusInPixels = 2.5;
                    CpuCountersDataSeries.CounterFrequencyPerPixel = (100 * 1000 * 1000) / ((CpuCountersDataSeries.PointRadiusInPixels * 2) + 4);
                    return CpuCountersDataSeries;
                }());
                CpuUsage.CpuCountersDataSeries = CpuCountersDataSeries;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                function CpuSwimlaneFactory(componentConfig, isVisible, selectionEnabled, graphBehaviour, currentTimespan, selectionTimespan) {
                    var swimlaneConfig = new DiagnosticsHub.SwimlaneConfiguration(componentConfig, currentTimespan, graphBehaviour);
                    swimlaneConfig.header.isBodyExpanded = isVisible;
                    var unitConverter = new DiagnosticsHub.LocalizedUnitConverter(swimlaneConfig.graph.jsonConfig.Units, swimlaneConfig.graph.resources);
                    var additionalSeries = [];
                    var cpuCounterDataSeries = new CpuUsage.CpuCountersDataSeries(swimlaneConfig.graph.jsonConfig.Series[0].DataSource.CounterId, swimlaneConfig.graph.timeRange, new DiagnosticsHub.LocalizedUnitConverter(swimlaneConfig.graph.jsonConfig.Units, swimlaneConfig.graph.resources), new DiagnosticsHub.ChartColorScheme("rgb(118, 174, 200)", "rgba(118, 174, 200, 0.65)"), true, swimlaneConfig.graph.resources[swimlaneConfig.graph.jsonConfig.Series[0].Legend], swimlaneConfig.graph.resources[swimlaneConfig.graph.jsonConfig.Series[0].LegendTooltip]);
                    var enabledDataSeries = new CpuUsage.EnabledDataSeries(cpuCounterDataSeries, swimlaneConfig.graph.jsonConfig.EnabledAtStart, swimlaneConfig.graph.resources["CpuGraphProfilingEnabled"]);
                    additionalSeries.push(cpuCounterDataSeries);
                    additionalSeries.push(enabledDataSeries);
                    swimlaneConfig.graph.jsonConfig.Series = [];
                    var graph = new DiagnosticsHub.MultiSeriesGraph(swimlaneConfig.graph, additionalSeries);
                    graph.container.setAttribute("aria-label", componentConfig.Title);
                    var leftScale = new DiagnosticsHub.Scale(swimlaneConfig.graph.scale, DiagnosticsHub.ScaleType.Left, unitConverter);
                    var rightScale = new DiagnosticsHub.Scale(swimlaneConfig.graph.scale, DiagnosticsHub.ScaleType.Right, unitConverter);
                    graph.scaleChangedEvent.addEventListener(leftScale.onScaleChanged.bind(leftScale));
                    graph.scaleChangedEvent.addEventListener(rightScale.onScaleChanged.bind(rightScale));
                    swimlaneConfig.header.unit = swimlaneConfig.graph.unit;
                    var swimlane = new DiagnosticsHub.SwimlaneBase(swimlaneConfig.header, swimlaneConfig.graph.height, currentTimespan, selectionTimespan);
                    graph.scaleChangedEvent.addEventListener(swimlane.onScaleChanged.bind(swimlane));
                    swimlane.addMainRegionControl(new DiagnosticsHub.SelectionOverlay(graph, currentTimespan, selectionTimespan, swimlaneConfig.id));
                    swimlane.addMainRegionControl(new DiagnosticsHub.GridLineRenderer(currentTimespan));
                    swimlane.addLeftRegionControl(leftScale);
                    swimlane.addRightRegionControl(rightScale);
                    return swimlane;
                }
                CpuUsage.CpuSwimlaneFactory = CpuSwimlaneFactory;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var _cpuSwimlaneMarshalerProxy = null;
                var CpuSwimlaneMarshaler = (function () {
                    function CpuSwimlaneMarshaler() {
                        if (_cpuSwimlaneMarshalerProxy === null) {
                            _cpuSwimlaneMarshalerProxy = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.Tools.CpuSampling.CpuToolSwimlaneMarshaler", {}, true);
                        }
                    }
                    CpuSwimlaneMarshaler.prototype.isToolSupported = function () {
                        return _cpuSwimlaneMarshalerProxy._call("isToolSupported");
                    };
                    return CpuSwimlaneMarshaler;
                }());
                CpuUsage.CpuSwimlaneMarshaler = CpuSwimlaneMarshaler;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var EnabledDataSeries = (function () {
                    function EnabledDataSeries(cpuDataSeries, enabledAtStart, legendText) {
                        var _this = this;
                        this._enabledAtStart = false;
                        this._toggleEvents = [];
                        this._dataWarehouseRequestHandle = 1;
                        this._droppedRequest = false;
                        this._newDataEvent = new DiagnosticsHub.AggregatedEvent();
                        this._colorScheme = new DiagnosticsHub.ChartColorScheme("#9FB861", "#71B252");
                        this._title = legendText;
                        this._tooltip = legendText;
                        this._marker = document.createElement("div");
                        this._marker.classList.add("countersDataSeries-marker");
                        this._marker.style.backgroundColor = this._colorScheme.lineColor;
                        this._marker.style.width = (2 * EnabledDataSeries.PointRadiusInPixels) + "px";
                        this._marker.style.height = (2 * EnabledDataSeries.PointRadiusInPixels) + "px";
                        this._cpuDataSeries = cpuDataSeries;
                        var cpuMarshaler = new CpuUsage.CpuSwimlaneMarshaler();
                        cpuMarshaler.isToolSupported()
                            .then(function (toolSupported) {
                            if (!toolSupported) {
                                return;
                            }
                            _this._enabledAtStart = enabledAtStart;
                            return DiagnosticsHub.DataWarehouse.loadDataWarehouse()
                                .then(function (dw) {
                                var countersContextData = {
                                    customDomain: {
                                        CounterId: EnabledDataSeries.counterId
                                    }
                                };
                                return dw.getFilteredData(countersContextData, EnabledDataSeries.analyzerId);
                            }).then(function (responseData) {
                                _this._countersResult = responseData;
                            }).done(function () {
                                _this._dataWarehouseRequestHandle = null;
                                _this._droppedRequest = false;
                                _this.requestUpdate();
                            });
                        });
                    }
                    Object.defineProperty(EnabledDataSeries, "counterId", {
                        get: function () {
                            return "CpuTool.Counters.CollectionEnabled";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(EnabledDataSeries, "analyzerId", {
                        get: function () {
                            return "66EDDDF1-2277-40F3-983A-6FF57A433ECB";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(EnabledDataSeries.prototype, "minValue", {
                        get: function () {
                            return Number.NaN;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(EnabledDataSeries.prototype, "maxValue", {
                        get: function () {
                            return Number.NaN;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(EnabledDataSeries.prototype, "tooltip", {
                        get: function () {
                            return this._tooltip;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(EnabledDataSeries.prototype, "title", {
                        get: function () {
                            return this._title;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(EnabledDataSeries.prototype, "marker", {
                        get: function () {
                            return this._marker;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(EnabledDataSeries.prototype, "newDataEvent", {
                        get: function () {
                            return this._newDataEvent;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    EnabledDataSeries.prototype.dispose = function () {
                        this._countersResult.dispose();
                        this._newDataEvent.dispose();
                    };
                    EnabledDataSeries.prototype.onViewportChanged = function (viewport) {
                        return;
                    };
                    EnabledDataSeries.prototype.getPointAtTimestamp = function (timestamp, pointToFind) {
                        if (pointToFind === void 0) { pointToFind = DiagnosticsHub.PointToFind.Nearest; }
                        if (this._cpuDataSeries.cachedPoints.length === 0 || (this._toggleEvents.length === 0 && !this._enabledAtStart)) {
                            return null;
                        }
                        var point = { Timestamp: timestamp, Value: 0 };
                        var pointCompare = function (left, right) {
                            return right.Timestamp.greater(left.Timestamp);
                        };
                        var enabled = true;
                        if (this._toggleEvents.length !== 0) {
                            var index = DiagnosticsHub.Utilities.findLessThan(this._toggleEvents, point, pointCompare);
                            if (this._toggleEvents[index].Timestamp.greater(timestamp)) {
                                enabled = this._enabledAtStart;
                            }
                            else if (this._toggleEvents[index].Value === 0.0) {
                                enabled = false;
                            }
                        }
                        if (!enabled) {
                            return null;
                        }
                        var index = this.getPointIndex(this._cpuDataSeries.cachedPoints, point.Timestamp, 0, this._cpuDataSeries.cachedPoints.length - 1, pointToFind);
                        point = this._cpuDataSeries.cachedPoints[index];
                        return {
                            timestamp: point.Timestamp,
                            tooltip: this._tooltip,
                            value: point.Value,
                            color: this._colorScheme
                        };
                    };
                    EnabledDataSeries.prototype.onDataUpdate = function (timestamp) {
                        this.requestUpdate();
                    };
                    EnabledDataSeries.prototype.draw = function (context, graphInformation) {
                        var _this = this;
                        if (this._cpuDataSeries.cachedPoints.length === 0 || graphInformation.chartRect.width === 0) {
                            return;
                        }
                        var minIndex = 0;
                        var maxIndex = this._cpuDataSeries.cachedPoints.length - 1;
                        var isEnabled = this._enabledAtStart;
                        context.save();
                        context.lineWidth = (graphInformation.chartRect.height < 100 ? 1 : 2);
                        context.fillStyle = this._colorScheme.lineFillColor;
                        context.strokeStyle = this._colorScheme.lineColor;
                        this._toggleEvents.forEach(function (point) {
                            if (point.Value > 0.5) {
                                minIndex = _this.getPointIndex(_this._cpuDataSeries.cachedPoints, point.Timestamp, 0, _this._cpuDataSeries.cachedPoints.length - 1, DiagnosticsHub.PointToFind.Nearest);
                                isEnabled = true;
                            }
                            else {
                                maxIndex = _this.getPointIndex(_this._cpuDataSeries.cachedPoints, point.Timestamp, 0, _this._cpuDataSeries.cachedPoints.length - 1, DiagnosticsHub.PointToFind.Nearest);
                                isEnabled = false;
                                _this.drawBetween(context, graphInformation, minIndex, maxIndex);
                            }
                        });
                        if (isEnabled) {
                            maxIndex = this._cpuDataSeries.cachedPoints.length - 1;
                            this.drawBetween(context, graphInformation, minIndex, maxIndex);
                        }
                        context.restore();
                    };
                    EnabledDataSeries.prototype.drawBetween = function (context, graphInformation, minIndex, maxIndex) {
                        var getYCoordinate = function (value) { return graphInformation.chartRect.height - DiagnosticsHub.Utilities.scaleToRange(value, graphInformation.gridY.min, graphInformation.gridY.max, 0, graphInformation.chartRect.height); };
                        var getXCoordinate = function (timestamp) { return DiagnosticsHub.Utilities.convertToPixel(timestamp, graphInformation.gridX, graphInformation.chartRect.width, false); };
                        context.beginPath();
                        for (var i = minIndex; i <= maxIndex; ++i) {
                            context.lineTo(getXCoordinate(this._cpuDataSeries.cachedPoints[i].Timestamp), getYCoordinate(this._cpuDataSeries.cachedPoints[i].Value));
                        }
                        context.stroke();
                        context.lineTo(getXCoordinate(this._cpuDataSeries.cachedPoints[maxIndex].Timestamp), getYCoordinate(graphInformation.gridY.min));
                        context.lineTo(getXCoordinate(this._cpuDataSeries.cachedPoints[minIndex].Timestamp), graphInformation.chartRect.height);
                        context.closePath();
                        context.fill();
                        var elapsedPerPixel = DiagnosticsHub.BigNumber.divideNumber(graphInformation.gridX.elapsed, graphInformation.chartRect.width);
                        if (DiagnosticsHub.BigNumber.convertFromNumber(EnabledDataSeries.CounterFrequencyPerPixel).greater(elapsedPerPixel)) {
                            for (var i = minIndex; i <= maxIndex; ++i) {
                                context.beginPath();
                                context.arc(getXCoordinate(this._cpuDataSeries.cachedPoints[i].Timestamp), getYCoordinate(this._cpuDataSeries.cachedPoints[i].Value), EnabledDataSeries.PointRadiusInPixels, 0, 2 * Math.PI);
                                context.fill();
                            }
                        }
                    };
                    EnabledDataSeries.prototype.requestUpdate = function () {
                        var _this = this;
                        if (this._dataWarehouseRequestHandle) {
                            this._droppedRequest = true;
                            return;
                        }
                        this._dataWarehouseRequestHandle = window.setTimeout(function () {
                            _this._countersResult.getResult(null)
                                .then(function (result) { return _this.cachePoints(result); })
                                .done(function () {
                                _this._dataWarehouseRequestHandle = null;
                                if (_this._droppedRequest) {
                                    window.setTimeout(_this.requestUpdate.bind(_this), DiagnosticsHub.Constants.TimeoutImmediate);
                                    _this._droppedRequest = false;
                                }
                            });
                        }, DiagnosticsHub.Constants.TimeoutImmediate);
                    };
                    EnabledDataSeries.prototype.cachePoints = function (result) {
                        var _this = this;
                        result.p.forEach(function (point) {
                            _this._toggleEvents.push({
                                Timestamp: new DiagnosticsHub.BigNumber(point.t.h, point.t.l),
                                Value: point.v,
                                ToolTip: point.tt
                            });
                        });
                        this._newDataEvent.invokeEvent(this);
                    };
                    EnabledDataSeries.prototype.getPointIndex = function (list, timestamp, minIndex, maxIndex, indexToFind) {
                        var pointComparator = function (left, right) {
                            return right.Timestamp.greater(left.Timestamp);
                        };
                        var pointToFind = { Timestamp: timestamp, Value: 0 };
                        switch (indexToFind) {
                            case DiagnosticsHub.PointToFind.LessThanOrEqual:
                                return DiagnosticsHub.Utilities.findLessThan(list, pointToFind, pointComparator, minIndex, maxIndex);
                            case DiagnosticsHub.PointToFind.GreaterThanOrEqual:
                                return DiagnosticsHub.Utilities.findGreaterThan(list, pointToFind, pointComparator, minIndex, maxIndex);
                            case DiagnosticsHub.PointToFind.Nearest:
                            default:
                                var minIndex = DiagnosticsHub.Utilities.findLessThan(list, pointToFind, pointComparator);
                                var maxIndex = Math.min(minIndex + 1, list.length - 1);
                                var minDelta = DiagnosticsHub.BigNumber.subtract(timestamp, list[minIndex].Timestamp);
                                var maxDelta = DiagnosticsHub.BigNumber.subtract(list[maxIndex].Timestamp, timestamp);
                                return minDelta.greater(maxDelta) ? maxIndex : minIndex;
                        }
                    };
                    EnabledDataSeries.PointRadiusInPixels = 2.5;
                    EnabledDataSeries.CounterFrequencyPerPixel = (100 * 1000 * 1000) / ((EnabledDataSeries.PointRadiusInPixels * 2) + 4);
                    return EnabledDataSeries;
                }());
                CpuUsage.EnabledDataSeries = EnabledDataSeries;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
//# sourceMappingURL=CpuSwimlane.js.map
// SIG // Begin signature block
// SIG // MIIkAQYJKoZIhvcNAQcCoIIj8jCCI+4CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // NE5jDA/qI0zVnfshdnhoeQahQ8aAP59cXaBPPMZvdnSg
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFcYwghXCAgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggbQwGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIC5SFDRgrGmGSoGEBFOCIb94HKhpt4PJwJ3tW/pa
// SIG // YLdkMEgGCisGAQQBgjcCAQwxOjA4oB6AHABDAHAAdQBT
// SIG // AHcAaQBtAGwAYQBuAGUALgBqAHOhFoAUaHR0cDovL21p
// SIG // Y3Jvc29mdC5jb20wDQYJKoZIhvcNAQEBBQAEggEAOzqC
// SIG // 8OVYqQWyXEFXU1qRqic1F7hQ/5z46wwfYnWbl+AS2i/8
// SIG // S6x6TbFJ9I84HXKXOFhcTGu8No/kjpztBEUejZv/49oj
// SIG // vUKCIYPNJeq0PLBCz/E7eaxbDXrJgF7eDGUqR8N8rCz/
// SIG // RO/53P0x4GCK5CYvOKG7R2Kqc6LqBJsZ87GonL+Cvze6
// SIG // iMOOE5qjg/Nx+re4NDcDW2L2jtBiYMN+j7S1dAY93crp
// SIG // ffdk1sn9aSNe0ZL+V8GuaIq++Jxl0xisF9AescvOmIHn
// SIG // skf7dvUJvgloR2IoL5rt88f8LwOwrAKJ9ZVuXon5ai0K
// SIG // Pwn/Ln2vPt4BIHg9WVg3B6ad35RKHaGCE0owghNGBgor
// SIG // BgEEAYI3AwMBMYITNjCCEzIGCSqGSIb3DQEHAqCCEyMw
// SIG // ghMfAgEDMQ8wDQYJYIZIAWUDBAIBBQAwggE9BgsqhkiG
// SIG // 9w0BCRABBKCCASwEggEoMIIBJAIBAQYKKwYBBAGEWQoD
// SIG // ATAxMA0GCWCGSAFlAwQCAQUABCA23paEsHCyQFOSWeoy
// SIG // z8qnTcxmxg6Dx6uDOM00bpEAMgIGWIurMimwGBMyMDE3
// SIG // MDIwOTAzNDMzNy42MzNaMAcCAQGAAgH0oIG5pIG2MIGz
// SIG // MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3Rv
// SIG // bjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWlj
// SIG // cm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BS
// SIG // MScwJQYDVQQLEx5uQ2lwaGVyIERTRSBFU046RjUyOC0z
// SIG // Nzc3LThBNzYxJTAjBgNVBAMTHE1pY3Jvc29mdCBUaW1l
// SIG // LVN0YW1wIFNlcnZpY2Wggg7NMIIGcTCCBFmgAwIBAgIK
// SIG // YQmBKgAAAAAAAjANBgkqhkiG9w0BAQsFADCBiDELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAO
// SIG // BgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29m
// SIG // dCBDb3Jwb3JhdGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0
// SIG // IFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5IDIwMTAw
// SIG // HhcNMTAwNzAxMjEzNjU1WhcNMjUwNzAxMjE0NjU1WjB8
// SIG // MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3Rv
// SIG // bjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWlj
// SIG // cm9zb2Z0IENvcnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNy
// SIG // b3NvZnQgVGltZS1TdGFtcCBQQ0EgMjAxMDCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAKkdDbx3EYo6
// SIG // IOz8E5f1+n9plGt0VBDVpQoAgoX77XxoSyxfxcPlYcJ2
// SIG // tz5mK1vwFVMnBDEfQRsalR3OCROOfGEwWbEwRA/xYIiE
// SIG // VEMM1024OAizQt2TrNZzMFcmgqNFDdDq9UeBzb8kYDJY
// SIG // YEbyWEeGMoQedGFnkV+BVLHPk0ySwcSmXdFhE24oxhr5
// SIG // hoC732H8RsEnHSRnEnIaIYqvS2SJUGKxXf13Hz3wV3Ws
// SIG // vYpCTUBR0Q+cBj5nf/VmwAOWRH7v0Ev9buWayrGo8noq
// SIG // CjHw2k4GkbaICDXoeByw6ZnNPOcvRLqn9NxkvaQBwSAJ
// SIG // k3jN/LzAyURdXhacAQVPIk0CAwEAAaOCAeYwggHiMBAG
// SIG // CSsGAQQBgjcVAQQDAgEAMB0GA1UdDgQWBBTVYzpcijGQ
// SIG // 80N7fEYbxTNoWoVtVTAZBgkrBgEEAYI3FAIEDB4KAFMA
// SIG // dQBiAEMAQTALBgNVHQ8EBAMCAYYwDwYDVR0TAQH/BAUw
// SIG // AwEB/zAfBgNVHSMEGDAWgBTV9lbLj+iiXGJo0T2UkFvX
// SIG // zpoYxDBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3Js
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9N
// SIG // aWNSb29DZXJBdXRfMjAxMC0wNi0yMy5jcmwwWgYIKwYB
// SIG // BQUHAQEETjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY1Jvb0Nl
// SIG // ckF1dF8yMDEwLTA2LTIzLmNydDCBoAYDVR0gAQH/BIGV
// SIG // MIGSMIGPBgkrBgEEAYI3LgMwgYEwPQYIKwYBBQUHAgEW
// SIG // MWh0dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9QS0kvZG9j
// SIG // cy9DUFMvZGVmYXVsdC5odG0wQAYIKwYBBQUHAgIwNB4y
// SIG // IB0ATABlAGcAYQBsAF8AUABvAGwAaQBjAHkAXwBTAHQA
// SIG // YQB0AGUAbQBlAG4AdAAuIB0wDQYJKoZIhvcNAQELBQAD
// SIG // ggIBAAfmiFEN4sbgmD+BcQM9naOhIW+z66bM9TG+zwXi
// SIG // qf76V20ZMLPCxWbJat/15/B4vceoniXj+bzta1RXCCtR
// SIG // gkQS+7lTjMz0YBKKdsxAQEGb3FwX/1z5Xhc1mCRWS3Tv
// SIG // QhDIr79/xn/yN31aPxzymXlKkVIArzgPF/UveYFl2am1
// SIG // a+THzvbKegBvSzBEJCI8z+0DpZaPWSm8tv0E4XCfMkon
// SIG // /VWvL/625Y4zu2JfmttXQOnxzplmkIz/amJ/3cVKC5Em
// SIG // 4jnsGUpxY517IW3DnKOiPPp/fZZqkHimbdLhnPkd/DjY
// SIG // lPTGpQqWhqS9nhquBEKDuLWAmyI4ILUl5WTs9/S/fmNZ
// SIG // JQ96LjlXdqJxqgaKD4kWumGnEcua2A5HmoDF0M2n0O99
// SIG // g/DhO3EJ3110mCIIYdqwUB5vvfHhAN/nMQekkzr3ZUd4
// SIG // 6PioSKv33nJ+YWtvd6mBy6cJrDm77MbL2IK0cs0d9LiF
// SIG // AR6A+xuJKlQ5slvayA1VmXqHczsI5pgt6o3gMy4SKfXA
// SIG // L1QnIffIrE7aKLixqduWsqdCosnPGUFN4Ib5KpqjEWYw
// SIG // 07t0MkvfY3v1mYovG8chr1m1rtxEPJdQcdeh0sVV42ne
// SIG // V8HR3jDA/czmTfsNv11P6Z0eGTgvvM9YBS7vDaBQNdrv
// SIG // CScc1bN+NR4Iuto229Nfj950iEkSMIIE2jCCA8KgAwIB
// SIG // AgITMwAAALCG6ZIgCl3q+AAAAAAAsDANBgkqhkiG9w0B
// SIG // AQsFADB8MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2Fz
// SIG // aGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UE
// SIG // ChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSYwJAYDVQQD
// SIG // Ex1NaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0EgMjAxMDAe
// SIG // Fw0xNjA5MDcxNzU2NTZaFw0xODA5MDcxNzU2NTZaMIGz
// SIG // MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3Rv
// SIG // bjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWlj
// SIG // cm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BS
// SIG // MScwJQYDVQQLEx5uQ2lwaGVyIERTRSBFU046RjUyOC0z
// SIG // Nzc3LThBNzYxJTAjBgNVBAMTHE1pY3Jvc29mdCBUaW1l
// SIG // LVN0YW1wIFNlcnZpY2UwggEiMA0GCSqGSIb3DQEBAQUA
// SIG // A4IBDwAwggEKAoIBAQDw5fCNlFmpmtdsCQd3FCFZXbc9
// SIG // eLg1rfUwMf/O4f/W6RrJg5gj+5AQwZLsOrxQbJC9XPFr
// SIG // rUyi9WGlh+EprKM8Et9/xACCzr20Cl/LuduatxktWu0H
// SIG // AK1U/TOs9vgSJEokZ1fauEuhrA+A+Tm9IA21p8QsS/Gh
// SIG // VubyLye5JsEzJdkrDDByUIRrkmqVjPL6CE24LiTVQ9Pc
// SIG // 6/N0aoizybRg3MllrV8J5RFqFDTB5FcGEkbmoL2EWiRC
// SIG // Q/a89CxVmVqNs4imqhKUIr6GtUqJjKpHsKDFHxuPnPBi
// SIG // bVSdMtOpxJtT6blyO78Xnq9YXJ3GK1Ahu9iWzDbvjaZz
// SIG // 2a27Q3AVAgMBAAGjggEbMIIBFzAdBgNVHQ4EFgQU/KgH
// SIG // UtnvKf6YQzwVXHRet39z4K8wHwYDVR0jBBgwFoAU1WM6
// SIG // XIoxkPNDe3xGG8UzaFqFbVUwVgYDVR0fBE8wTTBLoEmg
// SIG // R4ZFaHR0cDovL2NybC5taWNyb3NvZnQuY29tL3BraS9j
// SIG // cmwvcHJvZHVjdHMvTWljVGltU3RhUENBXzIwMTAtMDct
// SIG // MDEuY3JsMFoGCCsGAQUFBwEBBE4wTDBKBggrBgEFBQcw
// SIG // AoY+aHR0cDovL3d3dy5taWNyb3NvZnQuY29tL3BraS9j
// SIG // ZXJ0cy9NaWNUaW1TdGFQQ0FfMjAxMC0wNy0wMS5jcnQw
// SIG // DAYDVR0TAQH/BAIwADATBgNVHSUEDDAKBggrBgEFBQcD
// SIG // CDANBgkqhkiG9w0BAQsFAAOCAQEAkv2A93W9ZZA+F83V
// SIG // FYPFjgKRO6xOfWDvjzkGk5DjD6pFPYk/Av3sb7hQkAls
// SIG // hNI3IZmxwYZ2HeQNxo7/GOCi+ka1hXd0bk4MREXQvNK2
// SIG // BH5wSw/WqwdpVkp2ZOj5qkejo4bc9M9EuEkQW2eP0dp5
// SIG // rjrdh1MG6I9q/H/X5KOGRRUNkWIiOpBK49hoAUnJLQ5r
// SIG // eGwRAvSPTRFgc6gDIQ2X4w9ydbv96A646/wgQZ2Ok/3F
// SIG // M3M+OXq9ajQeOUdiEbUc71f0c4Nxn6gUZb7kA45NbcQB
// SIG // Mxt+V+yh8xyXqTin9Kg6OfmJNfxdoyKuCr2NDKsxEm7p
// SIG // vWEW7PQZOiSFYl+psqGCA3YwggJeAgEBMIHjoYG5pIG2
// SIG // MIGzMQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGlu
// SIG // Z3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMV
// SIG // TWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRN
// SIG // T1BSMScwJQYDVQQLEx5uQ2lwaGVyIERTRSBFU046RjUy
// SIG // OC0zNzc3LThBNzYxJTAjBgNVBAMTHE1pY3Jvc29mdCBU
// SIG // aW1lLVN0YW1wIFNlcnZpY2WiJQoBATAJBgUrDgMCGgUA
// SIG // AxUAvIT7nVsS2sc2hTuIZp6jFhjVzByggcIwgb+kgbww
// SIG // gbkxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5n
// SIG // dG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVN
// SIG // aWNyb3NvZnQgQ29ycG9yYXRpb24xDTALBgNVBAsTBE1P
// SIG // UFIxJzAlBgNVBAsTHm5DaXBoZXIgTlRTIEVTTjo1N0Y2
// SIG // LUMxRTAtNTU0QzErMCkGA1UEAxMiTWljcm9zb2Z0IFRp
// SIG // bWUgU291cmNlIE1hc3RlciBDbG9jazANBgkqhkiG9w0B
// SIG // AQUFAAIFANxGNIgwIhgPMjAxNzAyMDkwMDIxMjhaGA8y
// SIG // MDE3MDIxMDAwMjEyOFowdDA6BgorBgEEAYRZCgQBMSww
// SIG // KjAKAgUA3EY0iAIBADAHAgEAAgIBxjAHAgEAAgIbMDAK
// SIG // AgUA3EeGCAIBADA2BgorBgEEAYRZCgQCMSgwJjAMBgor
// SIG // BgEEAYRZCgMBoAowCAIBAAIDFuNgoQowCAIBAAIDB6Eg
// SIG // MA0GCSqGSIb3DQEBBQUAA4IBAQAYjBhhG6oLiiNv6mZo
// SIG // gqxukoDvyR7/qklj9SnQgR3cq3XaBEnK5RUjqFylWQ4h
// SIG // dcz+VtdfPhwDB95pqsLxwkSuqt7PP57+qMwQxp7GzGkY
// SIG // z5Yww9QXfepNIlQQYkQV+TgoJ721V0d/lIvcg+eSIqN0
// SIG // BciXCIEhMfvDXqtipg31ftSdx4yO02s4eMTVhaIzz4Pd
// SIG // SH0a/6iS3fIdXsPDyqjJZ3ICGYK5lV3irizgVWli51yK
// SIG // kzN89NnIw5U1fPhscCNu+D8WPH+vXgq96Qe3BuyvdwiJ
// SIG // E7cgbNafH2P8nJUoXxGb/l/Xn/HgGw9po4M5h/GyFY32
// SIG // z1CPVM+mQ3HLA+dnMYIC9TCCAvECAQEwgZMwfDELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAO
// SIG // BgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29m
// SIG // dCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWljcm9zb2Z0
// SIG // IFRpbWUtU3RhbXAgUENBIDIwMTACEzMAAACwhumSIApd
// SIG // 6vgAAAAAALAwDQYJYIZIAWUDBAIBBQCgggEyMBoGCSqG
// SIG // SIb3DQEJAzENBgsqhkiG9w0BCRABBDAvBgkqhkiG9w0B
// SIG // CQQxIgQgMcsg8tKbNezzYy6aSYclTQ5rQP5lYyShLFu4
// SIG // Uep3od4wgeIGCyqGSIb3DQEJEAIMMYHSMIHPMIHMMIGx
// SIG // BBS8hPudWxLaxzaFO4hmnqMWGNXMHDCBmDCBgKR+MHwx
// SIG // CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9u
// SIG // MRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMTHU1pY3Jv
// SIG // c29mdCBUaW1lLVN0YW1wIFBDQSAyMDEwAhMzAAAAsIbp
// SIG // kiAKXer4AAAAAACwMBYEFFHUlpu9yIf7hQbEOljWLP8r
// SIG // KJ7cMA0GCSqGSIb3DQEBCwUABIIBAN+WxSzmdoH2NuAU
// SIG // pOX3JK+vkgyfMv+/hm4+arZs3VI6H+VYUawQQjkWmSP6
// SIG // ByDOWKzYljgrZ4F/96p6/nJaNagUoHuvNFAJenuEmPqF
// SIG // Ijf9pF5a6YKQ3//SiY9RZr47VB8Pg32Yb04PMqg8jKK8
// SIG // +MYdIgLYvhr+xs24D3517sz/fLFNSI5AOu3PmB9xH5Fg
// SIG // JElS7BMwn2es6Bf8dO0J53dmOPPuJ6p4HGVVx4xVjT1O
// SIG // Sn5YF2qYU/720advdW3+USAMhBamP36t9ocYvoEV8Wh7
// SIG // PMm74xw/NjKWT622c5dVuAJA+TZJiY7zDh5tubXI4Ads
// SIG // gzBjg3lm7xJvGjYB3L0=
// SIG // End signature block
